/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import jclass.bwt.JCTextCursorEvent;
import jclass.bwt.JCTextEvent;
import jclass.bwt.JCTextInterface;
import jclass.field.JCNumberValidator;
import jclass.field.JCValidInfo;

public class JCDoubleValidator
extends JCNumberValidator {
    public static final double SAFE_DOUBLE_MAX = 1.7E100;
    public static final double SAFE_DOUBLE_MIN = -1.7E100;
    private static final boolean TRACE = false;

    public JCDoubleValidator() {
        super.setMax(new Double(1.7E100));
        super.setMin(new Double(-1.7E100));
        this.setIncrement(1.0);
    }

    public JCDoubleValidator(Double d, Double d2, Double d3, String string, boolean bl) {
        this.setMax(d2);
        this.setMin(d);
        this.setIncrement(d3);
        if (string != null) {
            this.setDisplayPattern(string);
        }
        this.setAllowNull(bl);
    }

    public void setMax(double d) {
        this.setMax(new Double(d));
    }

    public void setMin(double d) {
        this.setMin(new Double(d));
    }

    protected DecimalFormat createDisplayFormat(Locale locale) {
        return (DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault());
    }

    protected DecimalFormat createEditFormat(Locale locale) {
        return (DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault());
    }

    protected void setPatterns() {
        this.display_pattern = this.li.getString("DecimalPattern");
        this.edit_pattern = "0.###";
    }

    public void setCursor(JCTextCursorEvent jCTextCursorEvent) {
        jCTextCursorEvent.getNewPosition();
    }

    protected Object addIncrement(Object object) {
        if (this.increment == null || object == null) {
            return null;
        }
        double d = ((Number)object).doubleValue() + ((Number)this.increment).doubleValue();
        if (d > ((Number)this.getMax()).doubleValue()) {
            return null;
        }
        return new Double(d);
    }

    protected Object subtractIncrement(Object object) {
        if (this.increment == null || object == null) {
            return null;
        }
        double d = ((Number)object).doubleValue() - ((Number)this.increment).doubleValue();
        if (d < ((Number)this.getMin()).doubleValue()) {
            return null;
        }
        return new Double(d);
    }

    public Double getIncrement() {
        return (Double)this.increment;
    }

    public void setIncrement(Double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("increment <= 0.0");
        }
        this.increment = d;
    }

    public void setIncrement(double d) {
        this.setIncrement(new Double(d));
    }

    public boolean inRange(double d) {
        return !(d < ((Number)this.getMin()).doubleValue()) && !(d > ((Number)this.getMax()).doubleValue());
    }

    public boolean inRange(Number number) {
        return this.inRange(number.doubleValue());
    }

    public boolean inRange(Object object) {
        if (object instanceof Number) {
            return this.inRange(((Number)object).doubleValue());
        }
        return false;
    }

    public void changeText(JCTextEvent jCTextEvent) {
        char c;
        int n;
        boolean bl;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer(50);
        boolean bl2 = false;
        String string = ((JCTextInterface)jCTextEvent.getSource()).getText();
        if (string.indexOf(this.symbols.getDecimalSeparator()) != -1) {
            bl2 = true;
            boolean bl3 = bl = jCTextEvent.getEndPosition() - jCTextEvent.getStartPosition() > 0;
            if (bl && (n = string.substring(jCTextEvent.getStartPosition(), jCTextEvent.getEndPosition()).indexOf(this.symbols.getDecimalSeparator())) != -1) {
                bl2 = false;
            }
        }
        bl = false;
        n = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if (jCTextEvent.getStartPosition() == 0) {
            bl4 = true;
        } else if (string != null && string.length() > 1) {
            c = string.charAt(string.length() - 1);
            if (c == this.symbols.getMinusSign()) {
                bl5 = true;
            } else if (c == '+') {
                bl5 = true;
            } else if (c == ')') {
                bl5 = true;
            }
        }
        if (string.indexOf(this.symbols.getMinusSign()) != -1) {
            bl = true;
        } else if (string.indexOf(43) != -1) {
            bl = true;
        } else if (string.indexOf(40) != -1) {
            bl = true;
            n = 1;
        }
        String string2 = jCTextEvent.getText();
        if (string2 != null && string2.length() != 0) {
            stringBuffer = this.checkValidInvalid(string2);
            if (stringBuffer != null && stringBuffer.length() != 0) {
                int n2 = 0;
                while (n2 < stringBuffer.length()) {
                    c = stringBuffer.charAt(n2);
                    if (!bl5) {
                        if (Character.isDigit(c)) {
                            stringBuffer2.append(c);
                        } else if (!bl2 && c == this.symbols.getDecimalSeparator()) {
                            stringBuffer2.append(c);
                        } else if (!bl && c == this.symbols.getMinusSign()) {
                            stringBuffer2.append(c);
                        } else if ((c == '(' || c == ')') && this.edit_pattern.indexOf("(") != -1) {
                            if (c == '(' && bl4) {
                                stringBuffer2.append(c);
                            } else if (c == ')' && n != 0) {
                                stringBuffer2.append(c);
                            }
                        }
                    }
                    ++n2;
                }
            }
            jCTextEvent.setText(stringBuffer2.toString());
            if (stringBuffer2.length() == 0) {
                jCTextEvent.setAllowChange(false);
            }
        }
    }

    public JCValidInfo validateText(String string) {
        JCValidInfo jCValidInfo = this.parseFromDisplayList(string);
        if (jCValidInfo.valid) {
            return jCValidInfo;
        }
        jCValidInfo.value = null;
        if ((string == null || string.length() == 0) && this.getAllowNull()) {
            jCValidInfo.valid = true;
            return jCValidInfo;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.editFormat.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            jCValidInfo.valid = this.getAllowNull();
        } else {
            jCValidInfo.valid = true;
            jCValidInfo.value = number instanceof Double ? (Number)number : (Number)new Double(number.doubleValue());
        }
        if (!jCValidInfo.valid) {
            return jCValidInfo;
        }
        return this.validate(jCValidInfo.value);
    }

    public JCValidInfo validate(Object object) {
        JCValidInfo jCValidInfo = super.validate(object);
        if (!jCValidInfo.valid) {
            return jCValidInfo;
        }
        if (jCValidInfo.value != null && !this.inRange(object)) {
            jCValidInfo.valid = false;
            return jCValidInfo;
        }
        return jCValidInfo;
    }

    public String formatForEdit(Object object) {
        if (object == null) {
            return "";
        }
        String string = null;
        JCValidInfo jCValidInfo = this.formatFromDisplayList(object);
        string = jCValidInfo.valid ? (String)jCValidInfo.value : this.editFormat.format(object);
        return string;
    }

    public boolean hasEditFormat() {
        return true;
    }

    public String format(Object object) {
        if (object != null && !this.isSupported(object)) {
            object = this.convertToSupported(object);
        }
        JCValidInfo jCValidInfo = this.formatFromDisplayList(object);
        if (jCValidInfo.valid) {
            return (String)jCValidInfo.value;
        }
        if (object == null) {
            return "";
        }
        return this.displayFormat.format(object);
    }

    public boolean isSupported(Object object) {
        return object instanceof Double;
    }

    public Object convertToSupported(Object object) {
        if (object instanceof Number) {
            return new Double(((Number)object).doubleValue());
        }
        if (object instanceof BigDecimal) {
            return new Double(((BigDecimal)object).doubleValue());
        }
        return null;
    }

    public Object convertFromSupported(Object object, String string) {
        Double d = (Double)object;
        if (string.equals("java.lang.Float")) {
            return new Float(d.floatValue());
        }
        if (string.equals("java.math.BigDecimal")) {
            return new BigDecimal(d);
        }
        return null;
    }
}

